/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.morefurniture.datagen;

import com.mrcrayfish.furniture.common.ModTags;
import com.mrcrayfish.morefurniture.Generator;
import com.mrcrayfish.morefurniture.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.TagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ItemTagGen
extends ItemTagsProvider {
    public ItemTagGen(DataGenerator generator, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
        super(generator, blockTagsProvider, "morecfm", existingFileHelper);
    }

    private static Block getResultBlock(Generator.Variant variant, Generator.FurnitureType type, boolean stripped) {
        try {
            String fieldFormat = stripped ? "%s_%s_STRIPPED_%s" : "%s_%s_%s";
            String fieldName = String.format(fieldFormat, variant.getLog().getRegistryName().func_110624_b().toUpperCase(), type.getId().toUpperCase(), variant.getId().toUpperCase());
            RegistryObject block = (RegistryObject)ModBlocks.class.getField(fieldName).get(null);
            return (Block)block.get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void func_200432_c() {
        Generator generator = new Generator();
        TagsProvider.Builder bedroomTag = this.func_240522_a_(ModTags.Items.BEDROOM).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.BEDSIDE_CABINET, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.BEDSIDE_CABINET, true).getRegistryName());
            }
            bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.DESK, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.DESK, true).getRegistryName());
            }
            bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.DESK_CABINET, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.DESK_CABINET, true).getRegistryName());
            }
            bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.BLINDS, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            bedroomTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.BLINDS, true).getRegistryName());
        }
        TagsProvider.Builder generalTag = this.func_240522_a_(ModTags.Items.GENERAL).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            generalTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.TABLE, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                generalTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.TABLE, true).getRegistryName());
            }
            generalTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.CHAIR, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                generalTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.CHAIR, true).getRegistryName());
            }
            generalTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.COFFEE_TABLE, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            generalTag.addOptional(ItemTagGen.getResultBlock(variant, Generator.COFFEE_TABLE, true).getRegistryName());
        }
        TagsProvider.Builder builder = this.func_240522_a_(ModTags.Items.KITCHEN).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_COUNTER, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_COUNTER, true).getRegistryName());
            }
            builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_DRAWER, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_DRAWER, true).getRegistryName());
            }
            builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_LIGHT, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_LIGHT, true).getRegistryName());
            }
            builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_DARK, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            builder.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_DARK, true).getRegistryName());
        }
        TagsProvider.Builder builder2 = this.func_240522_a_(ModTags.Items.OUTDOORS).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            builder2.addOptional(ItemTagGen.getResultBlock(variant, Generator.PARK_BENCH, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder2.addOptional(ItemTagGen.getResultBlock(variant, Generator.PARK_BENCH, true).getRegistryName());
            }
            builder2.addOptional(ItemTagGen.getResultBlock(variant, Generator.MAIL_BOX, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder2.addOptional(ItemTagGen.getResultBlock(variant, Generator.MAIL_BOX, true).getRegistryName());
            }
            builder2.addOptional(ItemTagGen.getResultBlock(variant, Generator.MAIL_BOX, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            builder2.addOptional(ItemTagGen.getResultBlock(variant, Generator.MAIL_BOX, true).getRegistryName());
        }
        TagsProvider.Builder builder3 = this.func_240522_a_(ModTags.Items.STORAGE).replace(false);
        for (Generator.Variant variant : generator.getRegisteredVariants()) {
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.CABINET, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.CABINET, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.BEDSIDE_CABINET, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.BEDSIDE_CABINET, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.DESK_CABINET, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.DESK_CABINET, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.CRATE, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.CRATE, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.MAIL_BOX, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.MAIL_BOX, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_DRAWER, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_DRAWER, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_LIGHT, false).getRegistryName());
            if (variant.getStrippedLog() != null) {
                builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_LIGHT, true).getRegistryName());
            }
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_DARK, false).getRegistryName());
            if (variant.getStrippedLog() == null) continue;
            builder3.addOptional(ItemTagGen.getResultBlock(variant, Generator.KITCHEN_SINK_DARK, true).getRegistryName());
        }
    }
}

